<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

class DTWPB_VC_CLASS{
	
	public function __construct(){
		
		$vc_params_js = DT_WOO_PAGE_BUILDER_URL . '/assets/js/params.js';
		
		vc_add_shortcode_param( 'dtwpb_extra_options', array($this, 'dtwpb_extra_options_param' ), $vc_params_js );
		vc_add_shortcode_param( 'dtwpb_field_categories', array($this, 'dtwpb_setting_field_categories' ), $vc_params_js );
		vc_add_shortcode_param( 'dtwpb_field_tags', array($this, 'dtwpb_setting_field_tags' ), $vc_params_js );
		vc_add_shortcode_param( 'dtwpb_field_ids', array($this, 'dtwpb_setting_field_ids' ), $vc_params_js );
		
		add_action('vc_backend_editor_render', array($this,'enqueue_scripts'), 100 );
		
		$this->init();
	}
	
	public function init(){
		
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/wc-map-before.php';
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/product.php';
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/product-archive.php';
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/cart.php';
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/checkout.php';
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/thankyou.php';
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/myaccount-login.php';
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/myaccount.php';
		
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/account-details-shortcodes.php';
		
		require_once DT_WOO_PAGE_BUILDER_DIR . '/includes/js_composer/vc-map/wc-map-after.php';
	}
	
	public function dtwpb_setting_field_categories($settings, $value, $dependency=''){
		$category_ids = explode(',',$value);
		$args = array(
			'hide_empty' => 0,
		);
		$categories = get_terms( 'product_cat', $args );
		
		$multiple = isset($settings['multiple']) && $settings['multiple'] == false ? '':' multiple="multiple"';
		
		$output = '<select '.$dependency.' id= "'.$settings['param_name'].'" '.$multiple.' data-placeholder=" " class="dtwpb-select chosen_select_nostd">';
		if( isset($settings['only_top']) ){
			$output .= '<option value="0">' . esc_html__('Only Top Level','dt_woocommerce_page_builder') . '</option>';
		}else{
			$output .= '<option value="">' . esc_html__('-- Select --','dt_woocommerce_page_builder') . '</option>';
		}
		
		if( ! empty($categories)){
			foreach ($categories as $cat):
			$output .= '<option value="' . esc_attr( $cat->term_id ) . '"' . selected( in_array( $cat->term_id, $category_ids ), true, false ) . '>' . esc_html( $cat->name ) . '</option>';
			endforeach;
		}
		$output .= '</select>';
		$output .='<input id= "'.$settings['param_name'].'" type="hidden" class="wpb_vc_param_value wpb-textinput" name="'.$settings['param_name'].'" value="'.$value.'" />';
		return $output;
	}
	
	public function dtwpb_setting_field_tags($settings, $value, $dependency=''){
		$tags_ids = explode(',', $value);
	
		$args = array(
			'order_by'		=> 'name',
			'hide_empty'	=> 0
		);
		
		$tags = get_terms('product_tag', $args);
		$output = '<select '.$dependency.' id="'.$settings['param_name'].'" multiple="multiple" data-placeholder=" " class="dtwpb-select chosen_select_nostd">';
		if( ! empty($tags) ){
			foreach ($tags as $tag){
				$output .= '<option value="' . esc_attr($tag->term_id) . '" '. selected( in_array($tag->term_id, $tags_ids), true, false) .'>' . esc_html( $tag->name ) . '</option>';
			}
		}
		$output .= '</select>';
		$output .= '<input id= "'.$settings['param_name'].'" type="hidden" class="wpb_vc_param_value wpb-textinput" name="'.$settings['param_name'].'" value="'.$value.'" />';
		return $output;
	}
	
	function dtwpb_setting_field_ids($settings, $value, $dependency=''){
		$ids = explode(',',$value);
		$args = array(
			'limit' => -1,
		);
		$products = wc_get_products( $args );
		
		$multiple = isset($settings['multiple']) && $settings['multiple'] == false ? '':' multiple="multiple"';

		$output = '<select '.$dependency.' id="'.$settings['param_name'].'" '.$multiple.' data-placeholder=" " class="dtwpb-select chosen_select_nostd">';
		$output .= '<option value="">' . esc_html__('-- Select --','dt_woo_layouts') . '</option>';
		if( ! empty($products)){
			foreach ($products as $product):
			$output .= '<option value="' . esc_attr( $product->get_id() ) . '"' . selected( in_array( $product->get_id(), $ids ), true, false ) . '>' . esc_html( $product->name ) . '</option>';
			endforeach;
		}
		$output .= '</select>';
		$output .='<input id="'.$settings['param_name'].'" type="hidden" class="wpb_vc_param_value wpb-textinput" name="'.$settings['param_name'].'" value="'.$value.'" />';
		return $output;
	}
	
	public function dtwpb_extra_options_param( $settings, $value, $dependency='' ){
		
		$value_64 = base64_decode( $value );
		$value_arr = json_decode( $value_64 );
		if ( empty( $value_arr ) && ! is_array( $value_arr ) ) {
			for ( $i = 0; $i < 2; $i++ ) {
				$option = new stdClass();
				$option->content = '<input type="text" placeholder="Label" name="label" value=""><input type="text" placeholder="Value" name="value" value="">';
				$value_arr[] = $option;
			}
		}
		$param_line = '';
		$param_line .= '<div '.$dependency.' class="dtwpb_extra_options-list clearfix">';
		$param_line .= '<table>';
		$param_line .= '<thead>';
		$param_line .= '<tr>';
		$param_line .= '<td>';
		$param_line .= __( 'Apply for field type: dropdown, check, radio', 'dt_woocommerce_page_builder' );
		$param_line .= '</td>';
		$param_line .= '<td>';
		$param_line .= '</td>';
		$param_line .= '</tr>';
		$param_line .= '</thead>';
		$param_line .= '<tbody>';
		if ( is_array( $value_arr ) && ! empty( $value_arr ) ) {
			foreach ( $value_arr as $k => $v ) {
				$param_line .= '<tr>';
				$param_line .= '<td>';
				$param_line .= '<div id="content">';
				$param_line .= '<input type="text" placeholder="Label" name="label" value="' .  esc_attr($v->label)  . '">';
				$param_line .= '<input type="text" placeholder="Value" name="value" value="' .  esc_attr($v->value)  . '">';
				$param_line .= '</div>';
				$param_line .= '</td>';
				$param_line .= '<td align="left" style="padding:5px;">';
				$param_line .= '<a href="#" class="button" onclick="return dtwpb_extra_options_remove(this);"  title="' . esc_attr__( 'Remove', 'dt_woocommerce_page_builder' ) . '">' . esc_html__( 'Remove', 'dt_woocommerce_page_builder' ) . '</a>';
				$param_line .= '</td>';
				$param_line .= '</tr>';
			}
		}
		$param_line .= '</tbody>';
		$param_line .= '<tfoot>';
		$param_line .= '<tr>';
		$param_line .= '<td colspan="3">';
		$param_line .= '<a href="#" onclick="return dtwpb_extra_options_add(this);" class="button" title="' .__( 'Add', 'dt_woocommerce_page_builder' ) . '">' . __( 'Add', 'dt_woocommerce_page_builder' ) . '</a>';
		$param_line .= '</td>';
		$param_line .= '</tfoot>';
		$param_line .= '</table>';
		$param_line .= '<input type="hidden" name="' . $settings['param_name'] . '" class="wpb_vc_param_value' .$settings['param_name'] . ' ' . $settings['type'] . '" value="' . $value . '">';
		$param_line .= '</div>';
		return $param_line;
	}
	
	public function enqueue_scripts() {
		
		wp_register_script( 'dtwpb-vc-custom', DT_WOO_PAGE_BUILDER_URL . 'assets/js/vc-custom.js', array( 'jquery', 'jquery-ui-datepicker' ), '1.0.0', true );
			
		$dtwpb_extra_options_tmpl = '
			<tr>
				<td>
					<div id="content"><input type="text" placeholder="Label" name="label" value=""><input type="text" placeholder="Value" name="value" value=""></div>
				</td>
				<td align="left" style="padding:5px;">
					<a href="#" class="button" onclick="return dtwpb_extra_options_remove(this);"  title="' .esc_attr__( 'Remove', 'dt_woocommerce_page_builder' ) . '">'.esc_html__( 'Remove', 'dt_woocommerce_page_builder' ).'</a>
				</td>
			</tr>';
	
		$dtwpb_L10n = array(
			'dtwpb_extra_options_tmpl' => $dtwpb_extra_options_tmpl,
		);
		wp_localize_script( 'dtwpb-vc-custom', 'dtwpb_L10n', $dtwpb_L10n );
		wp_enqueue_script( 'dtwpb-vc-custom' );
	}
//
}

new DTWPB_VC_CLASS();
