<?php
/*
 * Contain all shortcodes for WooCommerce page builder
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit(); // Exit if accessed directly
}
$text_align_options = array( 
	esc_html__( 'Left', 'js_composer' ) => 'left', 
	esc_html__( 'Right', 'js_composer' ) => 'right', 
	esc_html__( 'Center', 'js_composer' ) => 'center', 
	esc_html__( 'Justify', 'js_composer' ) => 'justify' );
$show_hide_values = array( 
	esc_html__( 'Show', 'dt_woocommerce_page_builder' ) => 'show', 
	esc_html__( 'Hide', 'dt_woocommerce_page_builder' ) => 'hide' );
$order_by_values = array( 
	'', 
	esc_html__( 'Date', 'js_composer' ) => 'date', 
	esc_html__( 'Order by post ID', 'js_composer' ) => 'ID', 
	esc_html__( 'Author', 'js_composer' ) => 'author', 
	esc_html__( 'Title', 'js_composer' ) => 'title', 
	esc_html__( 'Last modified date', 'js_composer' ) => 'modified', 
	esc_html__( 'Random order', 'js_composer' ) => 'rand', 
	esc_html__( 'Number of comments', 'js_composer' ) => 'comment_count', 
	esc_html__( 'Menu order', 'dt_woocommerce_page_builder' ) => 'menu_order' );

$order_way_values = array( 
	'', 
	esc_html__( 'Descending', 'js_composer' ) => 'DESC', 
	esc_html__( 'Ascending', 'js_composer' ) => 'ASC' );

$border_type = array(
	esc_html__( 'None', 'dt_woocommerce_page_builder' ) => '',
	esc_html__( 'Solid', 'dt_woocommerce_page_builder' ) => 'solid',
	esc_html__( 'Double', 'dt_woocommerce_page_builder' ) => 'double',
	esc_html__( 'Dotted', 'dt_woocommerce_page_builder' ) => 'dotted',
	esc_html__( 'Dashed', 'dt_woocommerce_page_builder' ) => 'dashed',
	esc_html__( 'Groove', 'dt_woocommerce_page_builder' ) => 'groove',
);

vc_map( 
	array( 
		"name" =>esc_html__( "Category Thumbnail", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_product_category_thumbnail", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( "Displaying Category Thumbnail", 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Image size", 'dt_woocommerce_page_builder' ), 
				"param_name" => "thumbnail_size", 
				'value' => '', 
				"description" =>esc_html__( 
					'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)).', 
					'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
vc_map( 
	array( 
		"name" =>esc_html__( "Archive Header", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_archive_product_header", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( "Displaying Archive Title and Archive Description", 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
vc_map( 
	array( 
		"name" =>esc_html__( "Archive Header Title", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_archive_product_header_title", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( "Displaying Archive Title", 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "HTML Tag", 'dt_woocommerce_page_builder' ), 
				"param_name" => "tag", 
				'std' => 'h1', 
				'value' => array( 
					'h1' => 'h1', 
					'h2' => 'h2', 
					'h3' => 'h3', 
					'h4' => 'h4', 
					'h5' => 'h5', 
					'h6' => 'h6', 
					'p' => 'p', 
					'div' => 'div' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => $text_align_options ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Font size', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'font_size', 
				'description' => esc_html__( 'Enter font size.', 'dt_woocommerce_page_builder' ) ), 
			
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Line height', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'line_height', 
				'description' => esc_html__( 'Enter line height.', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'colorpicker', 
				'heading' => esc_html__( 'Color', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'color' ), 
			array( 
				'type' => 'checkbox', 
				'heading' => esc_html__( 'Use theme default font family?', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'use_fonts', 
				'value' => array( esc_html__( 'No', 'dt_woocommerce_page_builder' ) => 'no' ), 
				'description' => esc_html__( 'Use font family from the theme.', 'dt_woocommerce_page_builder' ) ), 
			
			array( 
				'type' => 'google_fonts', 
				'param_name' => 'google_fonts', 
				'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal', 
				'settings' => array( 
					'fields' => array( 
						'font_family_description' => esc_html__( 'Select font family.', 'dt_woocommerce_page_builder' ), 
						'font_style_description' => esc_html__( 'Select font styling.', 'dt_woocommerce_page_builder' ) ) ), 
				'dependency' => array( 'element' => 'use_fonts', 'value' => 'no' ) ), 
			vc_map_add_css_animation(), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
vc_map( 
	array( 
		"name" =>esc_html__( "Archive Header Description", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_archive_product_description", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( "Displaying Archive Description", 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => $text_align_options ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Font size', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'font_size', 
				'description' => esc_html__( 'Enter font size.', 'dt_woocommerce_page_builder' ) ), 
			
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Line height', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'line_height', 
				'description' => esc_html__( 'Enter line height.', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'colorpicker', 
				'heading' => esc_html__( 'Color', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'color' ), 
			array( 
				'type' => 'checkbox', 
				'heading' => esc_html__( 'Use theme default font family?', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'use_fonts', 
				'value' => array( esc_html__( 'No', 'dt_woocommerce_page_builder' ) => 'no' ), 
				'description' => esc_html__( 'Use font family from the theme.', 'dt_woocommerce_page_builder' ) ), 
			
			array( 
				'type' => 'google_fonts', 
				'param_name' => 'google_fonts', 
				'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal', 
				'settings' => array( 
					'fields' => array( 
						'font_family_description' => esc_html__( 'Select font family.', 'dt_woocommerce_page_builder' ), 
						'font_style_description' => esc_html__( 'Select font styling.', 'dt_woocommerce_page_builder' ) ) ), 
				'dependency' => array( 'element' => 'use_fonts', 'value' => 'no' ) ), 
			vc_map_add_css_animation(), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Archive Products Loop", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_woocommerce_shop_loop", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		'description' =>esc_html__( "Displaying product archives, including the main shop", 'dt_woocommerce_page_builder' ), 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Layout", 'dt_woocommerce_page_builder' ), 
				"param_name" => "layout", 
				'save_always' => true, 
				'value' => array( 
					esc_html__( 'Theme Default', 'dt_woocommerce_page_builder' ) => '', 
					esc_html__( 'Custom Content', 'dt_woocommerce_page_builder' ) => 'custom' ), 
				'std' => '', 
				"description" => '' ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "columns", 
				'value' => array( 
					'1' => '1', 
					'2' => '2', 
					'3' => '3', 
					'4' => '4', 
					'5' => '5', 
					'6' => '6', 
					'7' => '7', 
					'8' => '8', 
					'9' => '9', 
					'10' => '10', 
					'11' => '11', 
					'12' => '12' ), 
				'std' => '4', 
				'save_always' => true, 
				"description" => '' ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Tablet Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "tablet_columns", 
				'value' => array( '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6' ), 
				'std' => '3', 
				'dependency' => array( 'element' => 'layout', 'value' => 'custom' ), 
				"description" => '' ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Mobile Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "mobile_columns", 
				'value' => array( '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6' ), 
				'std' => '2', 
				'dependency' => array( 'element' => 'layout', 'value' => 'custom' ), 
				"description" => '' ), 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Rows", 'dt_woocommerce_page_builder' ), 
				"param_name" => "rows", 
				'save_always' => true, 
				'std' => '3', 
				'dependency' => array( 'element' => 'layout', 'value' => 'custom' ) ),
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Allow Order", 'dt_woocommerce_page_builder' ), 
				"param_name" => "allow_order", 
				'save_always' => true, 
				'value' => array( 
					esc_html__( 'Yes', 'dt_woocommerce_page_builder' ) => 'yes', 
					esc_html__( 'No', 'dt_woocommerce_page_builder' ) => 'no' ), 
				'std' => 'yes',
				"description" => '' ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Show Result Count", 'dt_woocommerce_page_builder' ), 
				"param_name" => "show_result_count", 
				'save_always' => true, 
				'value' => array( 
					esc_html__( 'Yes', 'dt_woocommerce_page_builder' ) => 'yes', 
					esc_html__( 'No', 'dt_woocommerce_page_builder' ) => 'no' ), 
				'std' => 'yes',
				"description" => '' ), 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Nothing Found Message", 'dt_woocommerce_page_builder' ), 
				"param_name" => "nothing_found_message", 
				'save_always' => true, 
				'std' =>esc_html__( "No products were found matching your selection.", 'dt_woocommerce_page_builder' ), 
				"description" => '' ),
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Columns Gap', 'dt_woocommerce_page_builder' ),
				'param_name' => 'column_gap', 
				'value' => '20', 
				'dependency' => array( 'element' => 'layout', 'value' => 'custom' ), 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Rows Gap', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'row_gap', 
				'value' => '40', 
				'dependency' => array( 'element' => 'layout', 'value' => 'custom' ), 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array(
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => array( 
					esc_html__( 'Left', 'js_composer' ) => 'left', 
					esc_html__( 'Right', 'js_composer' ) => 'right', 
					esc_html__( 'Center', 'js_composer' ) => 'center' ), 
				'dependency' => array( 'element' => 'layout', 'value' => 'custom' ), 
				'group' => esc_html__( 'Products', 'dt_woocommerce_page_builder' ) ), 
			array(
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) )

	 );

if ( is_active_sidebar( 'shop' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( "WooCommerce Sidebar", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_woocommerce_sidebar", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			'description' => '', 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

