<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce-page-builder-templates/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$theme = wc_get_theme_slug_for_templates();

get_header( 'shop' );

if( $theme == 'Impreza' && function_exists( 'us_woocommerce_before_main_content' ) ){
	us_woocommerce_before_main_content();
}

if( $theme == 'storefront' ):?>
<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">
<?php
endif;
?>
<?php
if( $theme == 'dt-the7' ):?>
<div id="content" class="content" role="main">
<?php
endif;
?>
<?php
if( $theme == 'kuteshop' ):?>
<div class="main-container shop-page full-sidebar">
<div class="container">
<?php
endif;
?>
<?php
if( $theme == 'u-design' ):?>
<div id="content-container" class="container_24">
	<div id="main-content">
		<div class="main-content-padding">
<?php
endif;
?>
<?php
if( $theme == 'werkstatt' ):?>
<div class="row full-width-row">
	<div class="small-12 columns small-order-1 large-order-2">
<?php
endif;
?>
<div class="dtwpb-woocommerce-product-achive <?php echo esc_attr( $theme );?>">
	<?php 
	if( $theme == 'woodmart' ):
	?>
	<div class="shop-loop-head">
		<div class="woodmart-woo-breadcrumbs">
			<?php woodmart_current_breadcrumbs( 'shop' ); ?>
			<?php woocommerce_result_count(); ?>
		</div>
		<div class="woodmart-shop-tools">
			<?php
				/**
				 * Hook: woocommerce_before_shop_loop.
				 *
				 * @hooked wc_print_notices - 10
				 * @hooked woocommerce_result_count - 20
				 * @hooked woocommerce_catalog_ordering - 30
				 */
				do_action( 'woocommerce_before_shop_loop' );
			?>
		</div>
	</div>
	<?php endif; ?>
	<?php
	if( $theme == 'shopme' ){
		woocommerce_output_content_wrapper();
	}
	?>

	<?php
	do_action('dtwpb_archive_product_content');
	?>
	
	<?php 
	if( $theme == 'shopme' ){
		woocommerce_output_content_wrapper_end();
	}
	?>
</div>
<?php
if( $theme == 'werkstatt' ):?>
	</div>
</div>
<?php
endif;
?>
<?php
if( $theme == 'u-design' ):?>
		</div>
	</div>
</div>
<?php
endif;
?>
<?php
if( $theme == 'kuteshop' ):?>
</div></div>
<?php
endif;
?>
<?php
if( $theme == 'dt-the7' ):?>
</div>
<?php
endif;
?>
<?php
if( $theme == 'Impreza' && function_exists( 'us_woocommerce_after_main_content' ) ){
	us_woocommerce_after_main_content();
}

if( $theme == 'storefront' ):?>
	</main><!-- #main -->
</div><!-- #primary -->
<?php
endif;
?>
<?php 
get_footer( 'shop' ); ?>
