<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce-page-builder-templates/content-single-product.php.
 *
 */

defined( 'ABSPATH' ) || exit;

global $product;

$theme = wc_get_theme_slug_for_templates();
?>

<?php
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
 
 $class = 'dtwpb-woocommerce-page summary '.$theme;
 if( $theme == 'jupiter' ){
 	$class .=' mk-product style-default';
 }
 if( $theme == 'superfood' ){
 	$class .=' eltdf-single-product-content';
 }
 
 $class = apply_filters('dtwpb_woocommerce_page_class',$class);
?>
<?php 
if( $theme == 'salient' || $theme == 'ic' ){
	$nectar_options        = get_nectar_theme_options(); 
	$product_style         = (!empty($nectar_options['product_style'])) ? $nectar_options['product_style'] : 'classic';
	$product_gallery_style = (!empty($nectar_options['single_product_gallery_type'])) ? $nectar_options['single_product_gallery_type'] : 'default';
	$product_hide_sku      = (!empty($nectar_options['woo_hide_product_sku'])) ? $nectar_options['woo_hide_product_sku'] : 'false';
?>
<div itemscope data-project-style="<?php echo esc_attr($product_style); ?>" data-hide-product-sku="<?php echo esc_attr($product_hide_sku); ?>" data-gallery-style="<?php echo esc_attr($product_gallery_style); ?>" data-tab-pos="<?php echo (!empty($nectar_options['product_tab_position'])) ? esc_attr($nectar_options['product_tab_position']) : 'default'; ?>" id="product-<?php the_ID(); ?>" <?php wc_product_class($class, $product); ?>>
<?php 
}else{ ?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( $class, $product ); ?>>
<?php } ?>

	<?php 
	/**
	 * dtwpb_product_content Hooks
	 *
	 * @hooked DTWPB_Manager -> the_product_page_content() - 10.
	 * @hooked DTWPB_Manager -> product_data() - 30.
	 */
	do_action('dtwpb_product_content');
	?>
</div>